create or replace package tbicds.PCK_PAT_ETHNICITY_RACE AUTHID CURRENT_USER is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  -- custom to return recordsets
  type RetRefCursor is ref cursor;

  procedure InsertPatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nEthnicityID     in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

  procedure InsertPatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nRaceID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2);

  procedure InsertPatEthRaceSource(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nSourceID        in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

  procedure GetEthnicityRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor);

  procedure GetRaceRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor);

  procedure GetEthRaceSourceRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor);

  procedure GetPatientEthnicityRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

  procedure GetPatientRaceRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID       in varchar2,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  function GetPatientRaceListString(pi_vPatientID in varchar2)
    return varchar2;

  procedure GetPatEthRaceSourceRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

  procedure DeletePatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

  procedure DeletePatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2);

  procedure DeletePatEthRaceSource(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

  procedure UpdatePatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              
                              pi_vPatientID in varchar2,
                              pi_vValues    in varchar2,
                              
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2);

  procedure UpdatePatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nEthnicityID     in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

end;
/

